#include <iostream>
#include <unordered_map>
#include <cmath>
#include <vector>
#include <map>
#include <algorithm>
#include <string>
#include <queue>
#include <fstream>
#include <random>
#include <Windows.h>
#include <stack>

#define _SILENCE_STDEXT_HASH_UPPER_BOUND_DEPRECATION_WARNING

struct Node {
	int i; //index
	int a; //curr
	int c; //capacity
	Node* next;
	Node* prev;
	Node(int i1, int a1, int c1) : i(i1), a(a1), c(c1), next(NULL), prev(NULL) {};
};

int main() {
	std::ios_base::sync_with_stdio(false);
	std::cin.tie(0);
	std::cout.tie(0);
	int n;
	std::cin >> n;
	std::vector<int> a(n), c(n);

	std::map<int, Node*> map;

	for (int i = 0; i < n; i++) {
		std::cin >> a[i];
	}
	for (int i = 0; i < n; i++) {
		std::cin >> c[i];
		if (i == 0) {
			Node* v = new Node(i, a[i], c[i]);
			map[i] = v;
		}
		else {
			Node* v = new Node(i, a[i], c[i]);
			v->prev = map[i - 1];
			map[i - 1]->next = v;
			map[i] = v;
		}
	}

	int q;
	std::cin >> q;

	for (int i = 0; i < q; i++) {
		int k, f;
		std::cin >> k >> f;
		k--;
		Node* head = map[k];
		if (head == nullptr) {
			auto it = map.upper_bound(k);
			if (it != map.end()) {
				head = it->second;
			}
			else {
				continue;
			}
		}
		while (head != nullptr && f > 0) {
			if (head->a + f >= head->c) {
				int k1 = head->i;
				f -= c[k1] - a[k1];
				a[k1] = c[k1];
				if (head->prev != NULL) {
					head->prev->next = head->next;
				}
				if (head->next != NULL) {
					head->next->prev = head->prev;
				}
				head = head->next;
				map.erase(k1);
			}
			else {
				head->a += f;
				a[head->i] += f;
				f = 0;
			}
		}
	}

	for (int i = 0; i < n; i++) {
		std::cout << a[i] << " ";
	}

	return 1;
}